//AIM: Filtering of long data sequences

//Overlap-add method using FFT-IFFT technique(without using inbuilt Scilab
//functions for DFT/IDFT or FFT/IFFT)

//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//Given that x(n)={1,2,3,4,5,6,7,8} and h(n)={1,2}
//Soln:
xn =[1 2 3 4 5 6 7 8]; //Nx=8
hn =[1 2];
//Since Nx=8,Nh=2 and we know Nx=m*Nh(so 8=m*2) giving m=4;and so x(n) has been
//partitioned into 4 blocks of length Nh=2
x0n =[1 2];
x1n =[3 4];
x2n =[5 6];
x3n =[7 8];
//Length of each partitioned input i.e x0n,x1n,x2n and x3n is 2(i.e. L=2)
//Here length of impulse response array h(n) is 2 (i.e. M=2) or Nh=2
//Hence,we pad the partitioned sequence and h(n) with zeros such that the length
// of each one becomes 'atleast' L+M-1 i.e. 3
//But since we know 4 point DFT matrix,we can pad an additional zero & make the
//length of each sequence =4
x0n_z=[1 2 0 0];//x0n_z represents zero pad is done to x0n
x1n_z=[3 4 0 0];//x1n_z represents zero pad is done to x1n
x2n_z=[5 6 0 0];//x2n_z represents zero pad is done to x2n
x3n_z=[7 8 0 0];//x3n_z represents zero pad is done to x3n
hn_z=[1 2 0 0];//hn_z represents zero pad is done to hn

//Computing FFT for x0n_z
x0n_z_0=1;//x0n_z_0 represents the 0th sample of x0n_z
x0n_z_1=2;//x0n_z_1 represents the 1st sample of x0n_z
x0n_z_2=0;//x0n_z_2 represents the 2nd sample of x0n_z
x0n_z_3=0;//x0n_z_3 represents the 3rd sample of x0n_z
X0_0=(x0n_z_2+x0n_z_0)*(1)+(x0n_z_3+x0n_z_1)*(1)
X0_1=(x0n_z_3-x0n_z_1)*(-1)*(-sqrt(-1))+(x0n_z_2-x0n_z_0)*(-1);
X0_2=((x0n_z_3+x0n_z_1)*(1)-(x0n_z_2+x0n_z_0)*(1))*(-1);
X0_3=((x0n_z_3-x0n_z_1)*(-1)*(-sqrt(-1))-(x0n_z_2-x0n_z_0)*(-1))*(-1);
disp({,X0_0,X0_1,X0_2,X0_3,},'So,the DFT of x0(n) using Decimation-in-Time Fast Fourier Transform(DIT-FFT) is X0(k)=')

//Computing FFT for x1n_z
x1n_z_0=3;//x1n_z_0 represents the 0th sample of x1n_z
x1n_z_1=4;//x1n_z_1 represents the 1st sample of x1n_z
x1n_z_2=0;//x1n_z_2 represents the 2nd sample of x1n_z
x1n_z_3=0;//x1n_z_3 represents the 3rd sample of x1n_z
X1_0=(x1n_z_2+x1n_z_0)*(1)+(x1n_z_3+x1n_z_1)*(1)
X1_1=(x1n_z_3-x1n_z_1)*(-1)*(-sqrt(-1))+(x1n_z_2-x1n_z_0)*(-1);
X1_2=((x1n_z_3+x1n_z_1)*(1)-(x1n_z_2+x1n_z_0)*(1))*(-1);
X1_3=((x1n_z_3-x1n_z_1)*(-1)*(-sqrt(-1))-(x1n_z_2-x1n_z_0)*(-1))*(-1);
disp({,X1_0,X1_1,X1_2,X1_3,},'So,the DFT of x1(n) using Decimation-in-Time Fast Fourier Transform(DIT-FFT) is X1(k)=')

//Computing FFT for x2n_z
x2n_z_0=5;//x2n_z_0 represents the 0th sample of x2n_z
x2n_z_1=6;//x2n_z_1 represents the 1st sample of x2n_z
x2n_z_2=0;//x2n_z_2 represents the 2nd sample of x2n_z
x2n_z_3=0;//x2n_z_3 represents the 3rd sample of x2n_z
X2_0=(x2n_z_2+x2n_z_0)*(1)+(x2n_z_3+x2n_z_1)*(1)
X2_1=(x2n_z_3-x2n_z_1)*(-1)*(-sqrt(-1))+(x2n_z_2-x2n_z_0)*(-1);
X2_2=((x2n_z_3+x2n_z_1)*(1)-(x2n_z_2+x2n_z_0)*(1))*(-1);
X2_3=((x2n_z_3-x2n_z_1)*(-1)*(-sqrt(-1))-(x2n_z_2-x2n_z_0)*(-1))*(-1);
disp({,X2_0,X2_1,X2_2,X2_3,},'So,the DFT of x2(n) using Decimation-in-Time Fast Fourier Transform(DIT-FFT) is X2(k)=')

//Computing FFT for x3n_z
x3n_z_0=7;//x3n_z_0 represents the 0th sample of x3n_z
x3n_z_1=8;//x3n_z_1 represents the 1st sample of x3n_z
x3n_z_2=0;//x3n_z_2 represents the 2nd sample of x3n_z
x3n_z_3=0;//x3n_z_3 represents the 3rd sample of x3n_z
X3_0=(x3n_z_2+x3n_z_0)*(1)+(x3n_z_3+x3n_z_1)*(1)
X3_1=(x3n_z_3-x3n_z_1)*(-1)*(-sqrt(-1))+(x3n_z_2-x3n_z_0)*(-1);
X3_2=((x3n_z_3+x3n_z_1)*(1)-(x3n_z_2+x3n_z_0)*(1))*(-1);
X3_3=((x3n_z_3-x3n_z_1)*(-1)*(-sqrt(-1))-(x3n_z_2-x3n_z_0)*(-1))*(-1);
disp({,X3_0,X3_1,X3_2,X3_3,},'So,the DFT of x3(n) using Decimation-in-Time Fast Fourier Transform(DIT-FFT) is X3(k)=')

//Computing FFT for hn_z
hn_z_0=1;//hn_z_0 represents the 0th sample of hn_z
hn_z_1=2;//hn_z_1 represents the 1st sample of hn_z
hn_z_2=0;//hn_z_2 represents the 2nd sample of hn_z
hn_z_3=0;//hn_z_3 represents the 3rd sample of hn_z
Hk_0=(hn_z_2+hn_z_0)*(1)+(hn_z_3+hn_z_1)*(1)
Hk_1=(hn_z_3-hn_z_1)*(-1)*(-sqrt(-1))+(hn_z_2-hn_z_0)*(-1);
Hk_2=((hn_z_3+hn_z_1)*(1)-(hn_z_2+hn_z_0)*(1))*(-1);
Hk_3=((hn_z_3-hn_z_1)*(-1)*(-sqrt(-1))-(hn_z_2-hn_z_0)*(-1))*(-1);
disp({,Hk_0,Hk_1,Hk_2,Hk_3,},'So,the DFT of h(n) using Decimation-in-Time Fast Fourier Transform(DIT-FFT) is H(k)=')

Y0k0=(X0_0).*(Hk_0);
Y0k1=(X0_1).*(Hk_1);
Y0k2=(X0_2).*(Hk_2);
Y0k3=(X0_3).*(Hk_3);
Y0k=[Y0k0 Y0k1 Y0k2 Y0k3];
disp(Y0k,'Y0(k)=')

//Computing IDFT of Y0k using IDIT-FFT :

Y0k0_0c=real(Y0k0)-(sqrt(-1))*imag(Y0k0);//Y0K0_0c means complex conjugate of Y0k0
Y0k0_1c=real(Y0k1)-(sqrt(-1))*imag(Y0k1);//Y0K0_1c means complex conjugate of Y0k1
Y0k0_2c=real(Y0k2)-(sqrt(-1))*imag(Y0k2);//Y0K0_2c means complex conjugate of Y0k2
Y0k0_3c=real(Y0k3)-(sqrt(-1))*imag(Y0k3);//Y0K0_3c means complex conjugate of Y0k3

a0=(((Y0k0_3c+Y0k0_1c)*(1))+((Y0k0_2c+Y0k0_0c)*(1)))*(1/4);
a1=(((Y0k0_3c-Y0k0_1c)*(-1)*(-sqrt(-1)))+(Y0k0_2c-Y0k0_0c)*(-1))*(1/4);
a2=(((Y0k0_3c+Y0k0_1c)*(1)-(Y0k0_2c+Y0k0_0c))*(-1))*(1/4);
a3=((((Y0k0_3c-Y0k0_1c)*(-1)*(-sqrt(-1)))-((Y0k0_2c-Y0k0_0c)*(-1)))*(-1))*(1/4);

a0_real=real(a0);
a0_conj=(-1)*(imag(a0));
a1_real=real(a1);
a1_conj=(-1)*(imag(a1));
a2_real=real(a2);
a2_conj=(-1)*(imag(a2));
a3_real=real(a3);
a3_conj=(-1)*(imag(a3));
//Finally, we will add the real part and the imaginary part whose complex
//conjugate is taken 
a0'=a0_real+a0_conj
a1'=a1_real+a1_conj
a2'=a2_real+a2_conj
a3'=a3_real+a3_conj
a=[a0',a1',a2',a3']
disp(a,'So,the IDFT of Y0(k) using Inverse Decimation-in-Time Fast Fourier Transform(IDIT-FFT) is y0(n)=')

Y1k0=(X1_0).*(Hk_0);
Y1k1=(X1_1).*(Hk_1);
Y1k2=(X1_2).*(Hk_2);
Y1k3=(X1_3).*(Hk_3);
Y1k=[Y1k0 Y1k1 Y1k2 Y1k3];
disp(Y1k,'Y1(k)=')

//Computing IDFT of Y1k using IDIT-FFT :
Y1k0_0c=real(Y1k0)-(sqrt(-1))*imag(Y1k0);//Y1K0_0c means complex conjugate of Y1k0
Y1k0_1c=real(Y1k1)-(sqrt(-1))*imag(Y1k1);//Y1K0_1c means complex conjugate of Y1k1
Y1k0_2c=real(Y1k2)-(sqrt(-1))*imag(Y1k2);//Y1K0_2c means complex conjugate of Y1k2
Y1k0_3c=real(Y1k3)-(sqrt(-1))*imag(Y1k3);//Y1K0_3c means complex conjugate of Y1k3

b0=(((Y1k0_3c+Y1k0_1c)*(1))+((Y1k0_2c+Y1k0_0c)*(1)))*(1/4);
b1=(((Y1k0_3c-Y1k0_1c)*(-1)*(-sqrt(-1)))+(Y1k0_2c-Y1k0_0c)*(-1))*(1/4);
b2=(((Y1k0_3c+Y1k0_1c)*(1)-(Y1k0_2c+Y1k0_0c))*(-1))*(1/4);
b3=((((Y1k0_3c-Y1k0_1c)*(-1)*(-sqrt(-1)))-((Y1k0_2c-Y1k0_0c)*(-1)))*(-1))*(1/4);

b0_real=real(b0);
b0_conj=(-1)*(imag(b0));
b1_real=real(b1);
b1_conj=(-1)*(imag(b1));
b2_real=real(b2);
b2_conj=(-1)*(imag(b2));
b3_real=real(b3);
b3_conj=(-1)*(imag(b3));
//Finally, we will add the real part and the imaginary part whose complex
//conjugate is taken 
b0'=b0_real+b0_conj
b1'=b1_real+b1_conj
b2'=b2_real+b2_conj
b=[b0',b1',b2',b3']
disp(b,'So,the IDFT of Y1(k) using Inverse Decimation-in-Time Fast Fourier Transform(IDIT-FFT) is y1(n)=')

Y2k0=(X2_0).*(Hk_0);
Y2k1=(X2_1).*(Hk_1);
Y2k2=(X2_2).*(Hk_2);
Y2k3=(X2_3).*(Hk_3);
Y2k=[Y2k0 Y2k1 Y2k2 Y2k3];
disp(Y2k,'Y2(k)=')

//Computing IDFT of Y2k using IDIT-FFT :
Y2k0_0c=real(Y2k0)-(sqrt(-1))*imag(Y2k0);//Y2K0_0c means complex conjugate of Y2k0
Y2k0_1c=real(Y2k1)-(sqrt(-1))*imag(Y2k1);//Y2K0_1c means complex conjugate of Y2k1
Y2k0_2c=real(Y2k2)-(sqrt(-1))*imag(Y2k2);//Y2K0_2c means complex conjugate of Y2k2
Y2k0_3c=real(Y2k3)-(sqrt(-1))*imag(Y2k3);//Y2K0_3c means complex conjugate of Y2k3

c0=(((Y2k0_3c+Y2k0_1c)*(1))+((Y2k0_2c+Y2k0_0c)*(1)))*(1/4);
c1=(((Y2k0_3c-Y2k0_1c)*(-1)*(-sqrt(-1)))+(Y2k0_2c-Y2k0_0c)*(-1))*(1/4);
c2=(((Y2k0_3c+Y2k0_1c)*(1)-(Y2k0_2c+Y2k0_0c))*(-1))*(1/4);
c3=((((Y2k0_3c-Y2k0_1c)*(-1)*(-sqrt(-1)))-((Y2k0_2c-Y2k0_0c)*(-1)))*(-1))*(1/4);

c0_real=real(c0);
c0_conj=(-1)*(imag(c0));
c1_real=real(b1);
c1_conj=(-1)*(imag(c1));
c2_real=real(c2);
c2_conj=(-1)*(imag(c2));
c3_real=real(c3);
c3_conj=(-1)*(imag(c3));
//Finally, we will add the real part and the imaginary part whose complex
//conjugate is taken 
c0'=c0_real+c0_conj
c1'=c1_real+c1_conj
c2'=c2_real+c2_conj
c3'=c3_real+c3_conj
c=[c0',c1',c2',c3']
disp(c,'So,the IDFT of Y2(k) using Inverse Decimation-in-Time Fast Fourier Transform(IDIT-FFT) is y2(n)=')

Y3k0=(X3_0).*(Hk_0);
Y3k1=(X3_1).*(Hk_1);
Y3k2=(X3_2).*(Hk_2);
Y3k3=(X3_3).*(Hk_3);
Y3k=[Y3k0 Y3k1 Y3k2 Y3k3];
disp(Y3k,'Y3(k)=')

//Computing IDFT of Y3k using IDIT-FFT :
Y3k0_0c=real(Y3k0)-(sqrt(-1))*imag(Y3k0);//Y3K0_0c means complex conjugate of Y3k0
Y3k0_1c=real(Y3k1)-(sqrt(-1))*imag(Y3k1);//Y3K0_1c means complex conjugate of Y3k1
Y3k0_2c=real(Y3k2)-(sqrt(-1))*imag(Y3k2);//Y3K0_2c means complex conjugate of Y3k2
Y3k0_3c=real(Y3k3)-(sqrt(-1))*imag(Y3k3);//Y3K0_3c means complex conjugate of Y3k3

d0=(((Y3k0_3c+Y3k0_1c)*(1))+((Y3k0_2c+Y3k0_0c)*(1)))*(1/4);
d1=(((Y3k0_3c-Y3k0_1c)*(-1)*(-sqrt(-1)))+(Y3k0_2c-Y3k0_0c)*(-1))*(1/4);
d2=(((Y3k0_3c+Y3k0_1c)*(1)-(Y3k0_2c+Y3k0_0c))*(-1))*(1/4);
d3=((((Y3k0_3c-Y3k0_1c)*(-1)*(-sqrt(-1)))-((Y3k0_2c-Y3k0_0c)*(-1)))*(-1))*(1/4);

d0_real=real(d0);
d0_conj=(-1)*(imag(d0));
d1_real=real(d1);
d1_conj=(-1)*(imag(d1));
d2_real=real(d2);
d2_conj=(-1)*(imag(d2));
d3_real=real(d3);
d3_conj=(-1)*(imag(d3));
//Finally, we will add the real part and the imaginary part whose complex
//conjugate is taken 
d0'=d0_real+d0_conj
d1'=d1_real+d1_conj
d2'=d2_real+d2_conj
d3'=d3_real+d3_conj
d=[d0',d1',d2',d3']
disp(d,'So,the IDFT of Y3(k) using Inverse Decimation-in-Time Fast Fourier Transform(IDIT-FFT) is y3(n)=')
w=[a 0 0 0 0 0 0];
x=[0 0 b 0 0 0 0];
y=[0 0 0 0 c 0 0];
z=[0 0 0 0 0 0 d];
disp(z,y,x,w,'After overlapping,the sequences will be seen as follows:')
yn=w+x+y+z;
disp(yn,'The output : y(n)=') 
